#include "testApp.h"

//--------------------------------------------------------------
void testApp::setup(){
	for(int i=0;i<1000;i++)stars.push_back(Star());
	ofEnableSmoothing();
	ofEnableAlphaBlending();
	glEnable(GL_LINE_SMOOTH);
	glHint(GL_LINE_SMOOTH_HINT,GL_NICEST);
	ofSetFrameRate(24);
}

//--------------------------------------------------------------
void testApp::update(){
	for(int i=0;i<stars.size();i++){
		stars[i].step();
	}
	
}

//--------------------------------------------------------------
void testApp::draw(){
	ofBackground(0,0,0);
	glColor4f(1,1,1,0.2);

	glPushMatrix();
	
	glTranslated(ofGetWidth()/2,ofGetHeight()/2, 0);
	
	//glRotatef(ofGetFrameNum()*0.1,0,1,0);
	
	for(int i=0;i<stars.size();i++){
		glPushMatrix();
		JPoint p = stars[i];
		p.rotateSelfX(ofGetFrameNum()*0.01*(stars[i].rnd[20]-0.5),JPoint());
		p.rotateSelfY(ofGetFrameNum()*0.01*(stars[i].rnd[21]-0.5),JPoint());
		p.rotateSelfZ(ofGetFrameNum()*0.01*(stars[i].rnd[22]-0.5),JPoint());
		p.glTranslate();
		stars[i].draw();
		glPopMatrix();
	}

	
	glPopMatrix();

	/*
	ofImage img;
	img.grabScreen(0,0,ofGetWidth(),ofGetHeight());
	
	char filename[256];
	sprintf(filename,"render_%05i.png",ofGetFrameNum());
	img.saveImage(filename);
	*/
}

//--------------------------------------------------------------
void testApp::keyPressed(int key){
}

//--------------------------------------------------------------
void testApp::keyReleased(int key){

}

//--------------------------------------------------------------
void testApp::mouseMoved(int x, int y ){

}

//--------------------------------------------------------------
void testApp::mouseDragged(int x, int y, int button){
	
}

//--------------------------------------------------------------
void testApp::mousePressed(int x, int y, int button){

}

//--------------------------------------------------------------
void testApp::mouseReleased(int x, int y, int button){

}

//--------------------------------------------------------------
void testApp::windowResized(int w, int h){

}

